	% Example 11.6
	clear all
	clc
	% Requirements for the digital lowpass filter
	wcT = 0.10*pi;			wsT = 0.35*pi;
	Amax = 0.1;				Amin = 40;
	% Requirements for the analog prototype lowpass filter
	T = 1;
	Wac = (2/T)*tan(wcT/2);	Was = (2/T)*tan(wsT/2);
	
	% Design of the analog prototype lowpass filter
	N = CA_ORDER_S(Wac, Was, Amax, Amin) 	% Must be an integer. 		
	N = 3;					% We select a 5th-order filter
	[G, Z, R_ZEROS, P, Wsnew] = CA_POLES_S(Wac, Was, Amax, Amin, N);
	Rs = 1; RL = 1; Ladder = 0; % 1 for a T ladder and 0 for a  ladder
	abc='a'
	[L, C, Rs, RL, W0, K] = CA_LADDER(G, Z, R_ZEROS, P, Wac, Was, Amax,Amin,Rs, RL, Ladder, abc)
	Z0 = []; T = 1;					% Used only for transmission lines
	omega = linspace(0, 10, 1000);
	H = LADDER_2_H(N, Z0, L, C, Rs, RL, K, omega, T);
	Anorm = MAG_2_ATT(H*2);			% Normalize the attenuation to 0 dB
	figure(1)
	subplot('position', [0.08 0.4 0.90 0.5]);
	axis([0, 10, 0, 60]);
	PLOT_ATT_S(omega, Anorm);	 
%	PLOT_LP_SPEC_S(Wac, Was, Amax, Amin); 	
% Transformation the analog prototype filter into a digital filter

	figure(2)
	[G, Z, P] = PZ_2_PZ_Z(G, Z, P, T)
	PLOT_PZ_Z(Z, P)

% Computation of attenuation and group delay
	figure(3)
	wT = linspace(0, pi, 1000);
	Att = PZ_2_ATT_Z(G, Z, P, wT);
	Taug = PZ_2_TG_Z(G, Z, P, wT);
	axis_Amax = 60;		axis_Tg_max = 15;
	PLOT_ATT_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)

	zoom on
	%=========	
	R1 = 1/C(1); R2L = L(2); R2C = 1/C(2); R3 = 1/C(3);
	Rs = 1; RL = 1;
	% Adaptor I PARALLEL
	G4 = 1/Rs + 1/R1; R4 = 1/G4;
	alfa11 = 2/Rs/(1/Rs + 1/R1 + G4);
%	alfa12 = 2/R1/(1/Rs + 1/R1 + G4);
%	alfa13 = 1;
	% Adaptor III PARALLEL
	G3 = 1/R3; GL = 1/RL;G6 = G3 + GL; R6 = 1/G6;
%	alfa31 = 2*G6/(G6 + G3 + GL);
	alfa32 = 2*G3/(G6 + G3 + GL);
%	alfa33 = 2*GL/(G6 + G3 + GL);	
	% Adaptor IV PARALLEL
	G2C = 1/R2C; G2L = 1/R2L; G5 = G2C + G2L; R5 = 1/G5;
	alfa41 = 2*G2L/(G5 + G2C + G2L);
%	alfa42 = 2*G5/(G5 + G2C + G2L);
%	alfa43 = 2*G2C/(G5 + G2C + G2L );
	% Adaptor II SERIES 
	alfa21 = 2*R4/(R4 + R5 + R6);	
	alfa22 = 2*R5/(R4 + R5 + R6);
%	alfa23 = 2*R6/(R4 + R5 + R6);
	
	a1 = 1; a2 = 0; v1 = 0; v2 = 0; v3 = 0; v4 = 0;
	for n = 1:50
		T11 = v1 - a1;	T21 = -alfa11*T11; x1 = T21 + v1; % Adaptor I
		T13 = a2 - v4; T23 = -alfa32*T13; x3 = T23 + a2; % Adaptor III
		T14 = v3 + v2; T24 = -alfa41*T14; x2 = T24 + v3; % Adaptor IV	
		A0 = x1 + x2 + x3; % Adaptor II
		u1 = x1 - alfa21*A0; u2 = x2 - alfa22*A0; u3 = -(A0 + u1 + u2); 
		v1 = T21 + u1; b1 = T11 + v1; % Adaptor I  			
		b2 = T23 + u3; v4 = T13 + b2; % Adaptor III			
		v3 = T24 + u2; v2 = T14 + v3; % Adaptor IV		
		a1 = 0;			% reset the input
		h(n) = b2;
	end
	figure(4)
	PLOT_IMPULSE_RESPONSE_Z(h)	
	figure(5)
	[G, Z, P] = IMPULSE_2_P_Z(h, 3);
	PLOT_PZ_Z(Z, P)
